
-- 

USE BD_Air_France;

IF OBJECT_ID ('dbo.T_aeroport_aer','U') IS NOT NULL
    DROP TABLE dbo.T_aeroport_aer;
GO
CREATE TABLE T_aeroport_aer
(aer_OACI VARCHAR(4), aer_nom VARCHAR(25), aer_OACI_resp VARCHAR(4));
GO

INSERT INTO T_aeroport_aer VALUES ('LFPG', 'Paris Charles de Gaule', NULL);
INSERT INTO T_aeroport_aer VALUES ('LFPO', 'Paris Orly', 'LFPG');
INSERT INTO T_aeroport_aer VALUES ('LFBO', 'Toulouse Blagnac', 'LFBD');
INSERT INTO T_aeroport_aer VALUES ('LFBD', 'Bordeaux Merignac', 'LFPO');
INSERT INTO T_aeroport_aer VALUES ('LFCI', 'ALbi', 'LFBO');
INSERT INTO T_aeroport_aer VALUES ('LFCK', 'Castres', 'LFBO');
INSERT INTO T_aeroport_aer VALUES ('LFMW', 'Castelnaudary', 'LFBO');
INSERT INTO T_aeroport_aer VALUES ('LFMT', 'Montpellier Fregorgues', 'LFMM');
INSERT INTO T_aeroport_aer VALUES ('LFMM', 'Marseille Marignane', 'LFPO');

-- 192

WITH Q_compte_aero (aeroport, nbr)
AS (SELECT aer_OACI_resp,COUNT(aer_OACI) AS nbr
      FROM   T_aeroport_aer 
      GROUP  BY aer_OACI_resp)
SELECT aeroport, nbr
FROM   Q_compte_aero 
WHERE  nbr = (SELECT MAX(nbr) FROM Q_compte_aero);

-- 193, WITH rcursif

WITH Q_sous_Paris_Orly (aer_OACI, aer_OACI_resp, niveau) 
 AS  (SELECT aer_OACI, aer_OACI_resp, 0 niveau
     FROM   T_aeroport_aer 
     WHERE  aer_OACI = 'LFPO'
    UNION ALL
     SELECT  a.aer_OACI, a.aer_OACI_resp, niveau+1
     FROM    Q_sous_Paris_Orly sp, T_aeroport_aer a
     WHERE   sp.aer_OACI = a.aer_OACI_resp)
SELECT aer_OACI_resp, CONCAT(SPACE(2*niveau),aer_OACI), niveau
FROM   Q_sous_Paris_Orly 
WHERE  niveau > 0
ORDER BY niveau, aer_OACI;

--

WITH Q_sous_Paris_Orly (aer_OACI, aer_OACI_resp, niveau, liste) 
 AS  (SELECT aer_OACI, aer_OACI_resp, 0 niveau, CAST(aer_OACI_resp AS VARCHAR(25))
     FROM   T_aeroport_aer 
     WHERE  aer_OACI = 'LFPO'
    UNION ALL
     SELECT  a.aer_OACI, a.aer_OACI_resp, niveau+1,
              CAST(liste+','+a.aer_OACI_resp AS VARCHAR(25))
     FROM    Q_sous_Paris_Orly sp, T_aeroport_aer a
     WHERE   sp.aer_OACI = a.aer_OACI_resp)
SELECT aer_OACI, niveau, liste
FROM   Q_sous_Paris_Orly 
ORDER BY niveau, aer_OACI;


-- 194, graphes orients


IF OBJECT_ID ('dbo.T_autoroute_aut','U') IS NOT NULL
    DROP TABLE dbo.T_autoroute_aut;
GO

CREATE TABLE T_autoroute_aut
(aut_ville_de VARCHAR(16), aut_ville_vers VARCHAR(16), aut_km SMALLINT);
GO

INSERT INTO T_autoroute_aut VALUES ('PARIS', 'NANTES', 385);
INSERT INTO T_autoroute_aut VALUES ('PARIS', 'CLERMONT-FERRAND', 420);
INSERT INTO T_autoroute_aut VALUES ('PARIS', 'LYON', 470);
INSERT INTO T_autoroute_aut VALUES ('CLERMONT-FERRAND', 'MONTPELLIER', 335);
INSERT INTO T_autoroute_aut VALUES ('CLERMONT-FERRAND', 'TOULOUSE', 375);
INSERT INTO T_autoroute_aut VALUES ('LYON', 'MONTPELLIER', 305);
INSERT INTO T_autoroute_aut VALUES ('LYON', 'MARSEILLE', 320);
INSERT INTO T_autoroute_aut VALUES ('MONTPELLIER', 'TOULOUSE', 240);
INSERT INTO T_autoroute_aut VALUES ('MARSEILLE', 'NICE', 205);

-- 195

WITH Q_trajets(ville_vers, etape) 
AS
   (SELECT DISTINCT aut_ville_de, 0
      FROM   T_autoroute_aut
      WHERE  aut_ville_de = 'PARIS'
    UNION  ALL
    SELECT  a.aut_ville_vers, t.etape + 1
      FROM  T_autoroute_aut a
      INNER JOIN Q_trajets t
      ON     t.ville_vers  = a.aut_ville_de)
SELECT ville_vers, etape
FROM   Q_trajets
WHERE  ville_vers = 'TOULOUSE';

-- 

WITH Q_trajets(ville_vers, etape, distance) 
AS
   (SELECT DISTINCT aut_ville_de, 0,0
      FROM   T_autoroute_aut
      WHERE  aut_ville_de = 'PARIS'
    UNION  ALL
    SELECT  a.aut_ville_vers, t.etape+1, t.distance+a.aut_km
      FROM  T_autoroute_aut a
      INNER JOIN Q_trajets t
      ON     t.ville_vers  = a.aut_ville_de)
SELECT ville_vers, etape, distance
FROM   Q_trajets
WHERE  ville_vers = 'TOULOUSE';

-- dtail des trajets

WITH Q_trajets(ville_vers, etape, distance, trajet) 
AS
   (SELECT DISTINCT aut_ville_de, 0,0, CAST('PARIS' AS VARCHAR(50))
      FROM   T_autoroute_aut
      WHERE  aut_ville_de = 'PARIS'
    UNION  ALL
    SELECT  a.aut_ville_vers, t.etape+1, t.distance+a.aut_km,
            CAST(t.trajet+','+ a.aut_ville_vers AS VARCHAR(50))
      FROM  T_autoroute_aut a
      INNER JOIN Q_trajets t
      ON     t.ville_vers  = a.aut_ville_de)
SELECT trajet, distance
FROM   Q_trajets
WHERE  ville_vers = 'TOULOUSE'
ORDER BY distance;

-- 196, graphe non orient

--insertion des routes inverses

INSERT INTO T_autoroute_aut
SELECT aut_ville_vers,aut_ville_de, aut_km FROM T_autoroute_aut;


WITH Q_trajets(ville_vers, etape, distance, trajet) 
AS
   (SELECT DISTINCT aut_ville_de, 0,0, CAST('PARIS' AS VARCHAR(50))
      FROM   T_autoroute_aut
      WHERE  aut_ville_de = 'PARIS'
    UNION  ALL
    SELECT  a.aut_ville_vers, t.etape+1, t.distance+a.aut_km,
            CAST(t.trajet+','+ a.aut_ville_vers AS VARCHAR(50))
      FROM  T_autoroute_aut a
      INNER JOIN Q_trajets t
      ON     t.ville_vers  = a.aut_ville_de
      AND    t.trajet NOT LIKE '%'+a.aut_ville_vers+'%'
      AND    t.etape <10)
SELECT trajet, distance
FROM   Q_trajets
WHERE  ville_vers = 'TOULOUSE'
ORDER BY distance;

-- nettoyage

IF OBJECT_ID ('dbo.T_aeroport_aer','U') IS NOT NULL
    DROP TABLE dbo.T_aeroport_aer;
GO

IF OBJECT_ID ('dbo.T_autoroute_aut','U') IS NOT NULL
    DROP TABLE dbo.T_autoroute_aut;
GO










